

#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <stdlib.h>




#define F_CPU 16000000UL 		        //    (16 MHz)
#define INCDIRECTION		YDIR	    //   XDIR (), YDIR ()



#include "proc.h"						//  
#include "adjectives.h"					//  
#include "keyboard.h"					// 
#include "lcd.h"						//  +   (, , )
#include "draw_spr.h"					//  
#include "chr.h"						//  
#include "sdcard.h"						//   SD 
#include "window.h"						// 

#include "spritefon.h";
#include "spritehide.h";
#include "spriteshow.h";



unsigned char tek[40];
unsigned char old[40];
unsigned char kp;		//   
unsigned char firepos;  //  
unsigned char chelpos;  //  
unsigned int firepause; //    
unsigned int movepause; //    
unsigned char tekmove; //   
unsigned int total;// 
unsigned int bad; //  
#define cFirePause 5000 //    
#define cMovePause 2500 //    


//   
void ShowGameScreen()
{
prm_spr(fon0);
prm_spr(fon1);
prm_spr(fon2);
prm_spr(fon3);
prm_spr(show62);
}

void ShowStartScreen()
{
ShowGameScreen();
char txt[]=" ";
char txt0[]="  ";
char txt1[]="  ";
put_string8(176/2-width_string(txt)/2,50,txt,0,255);
put_string8(176/2-width_string(txt0)/2,59,txt0,0,255);
put_string8(176/2-width_string(txt1)/2,66,txt1,0,255);
wait_key_pressed();
wait_key_unpressed()
fillscreen(255);
ShowGameScreen();
}


void ShowEndScreen()
{
ShowGameScreen();
char txt[]=" ";
char txt1[]="  ";
put_string8(176/2-width_string(txt)/2,50,txt,0,255);
put_string8(176/2-width_string(txt1)/2,59,txt1,0,255);
wait_key_pressed();
wait_key_unpressed()
fillscreen(255);
ShowGameScreen();
}


//  
void RefreshScreen()
{
if ((tek[0]==1) & (old[0]==0)) prm_spr(show0);

if ((tek[1]==1) & (old[1]==0)) prm_spr(show1);

if ((tek[2]==1) & (old[2]==0)) prm_spr(show2);

if ((tek[3]==1) & (old[3]==0)) prm_spr(show3);

if ((tek[4]==1) & (old[4]==0)) prm_spr(show4);

if ((tek[5]==1) & (old[5]==0)) prm_spr(show5);

if ((tek[6]==1) & (old[6]==0)) prm_spr(show6);

if ((tek[7]==1) & (old[7]==0)) prm_spr(show7);

if ((tek[8]==1) & (old[8]==0)) prm_spr(show8);

if ((tek[9]==1) & (old[9]==0)) prm_spr(show9);

if ((tek[10]==1) & (old[10]==0)) prm_spr(show10);

if ((tek[11]==1) & (old[11]==0)) prm_spr(show11);

if ((tek[12]==1) & (old[12]==0)) prm_spr(show12);

if ((tek[13]==1) & (old[13]==0)) prm_spr(show13);

if ((tek[14]==1) & (old[14]==0)) prm_spr(show14);

if ((tek[15]==1) & (old[15]==0)) prm_spr(show15);

if ((tek[16]==1) & (old[16]==0)) prm_spr(show16);

if ((tek[17]==1) & (old[17]==0)) prm_spr(show17);

if ((tek[18]==1) & (old[18]==0)) prm_spr(show18);

if ((tek[19]==1) & (old[19]==0)) prm_spr(show19);

if ((tek[20]==1) & (old[20]==0)) prm_spr(show20);

if ((tek[21]==1) & (old[21]==0)) prm_spr(show21);

if ((tek[22]==1) & (old[22]==0)) prm_spr(show22);

// 
if ((tek[23]==1) & (old[23]==0)) {
prm_spr(show23);
prm_spr(show24);
}
// 
if ((tek[24]==1) & (old[24]==0)) {
prm_spr(show25);
prm_spr(show26);
prm_spr(show27);
}
// 
if ((tek[25]==1) & (old[25]==0)) {
prm_spr(show28);
prm_spr(show29);
}
// 
if ((tek[26]==1) & (old[26]==0)) {
prm_spr(show30);
prm_spr(show31);
prm_spr(show32);
prm_spr(show33);
}
// 
if ((tek[27]==1) & (old[27]==0)) {
prm_spr(show34);
prm_spr(show35);
prm_spr(show36);
prm_spr(show37);
}
// 
if ((tek[28]==1) & (old[28]==0)) {
prm_spr(show38);
prm_spr(show39);
prm_spr(show40);
prm_spr(show41);
}

// 
if ((tek[29]==1) & (old[29]==0)) {
prm_spr(show42);
prm_spr(show43);
prm_spr(show44);
}

// 
if ((tek[30]==1) & (old[30]==0)) {
prm_spr(show45);
prm_spr(show46);
prm_spr(show47);
prm_spr(show48);
prm_spr(show49);
}
// 
if ((tek[31]==1) & (old[31]==0)) {
prm_spr(show50);
prm_spr(show51);
prm_spr(show52);
prm_spr(show53);
}
// 
if ((tek[32]==1) & (old[32]==0)) {
prm_spr(show54);
prm_spr(show55);
prm_spr(show56);
}
//
if ((tek[33]==1) & (old[33]==0))prm_spr(show57);

if ((tek[34]==1) & (old[34]==0))prm_spr(show58);

if ((tek[35]==1) & (old[35]==0))prm_spr(show59);
// 
if ((tek[36]==1) & (old[36]==0)) {
prm_spr(show60);
prm_spr(show61);
}

if ((tek[0]==0) & (old[0]==1)) prm_spr(hide0);

if ((tek[1]==0) & (old[1]==1)) prm_spr(hide1);

if ((tek[2]==0) & (old[2]==1)) prm_spr(hide2);

if ((tek[3]==0) & (old[3]==1)) prm_spr(hide3);

if ((tek[4]==0) & (old[4]==1)) prm_spr(hide4);

if ((tek[5]==0) & (old[5]==1)) prm_spr(hide5);

if ((tek[6]==0) & (old[6]==1)) prm_spr(hide6);

if ((tek[7]==0) & (old[7]==1)) prm_spr(hide7);

if ((tek[8]==0) & (old[8]==1)) prm_spr(hide8);

if ((tek[9]==0) & (old[9]==1)) prm_spr(hide9);

if ((tek[10]==0) & (old[10]==1)) prm_spr(hide10);

if ((tek[11]==0) & (old[11]==1)) prm_spr(hide11);

if ((tek[12]==0) & (old[12]==1)) prm_spr(hide12);

if ((tek[13]==0) & (old[13]==1)) prm_spr(hide13);

if ((tek[14]==0) & (old[14]==1)) prm_spr(hide14);

if ((tek[15]==0) & (old[15]==1)) prm_spr(hide15);

if ((tek[16]==0) & (old[16]==1)) prm_spr(hide16);

if ((tek[17]==0) & (old[17]==1)) prm_spr(hide17);

if ((tek[18]==0) & (old[18]==1)) prm_spr(hide18);

if ((tek[19]==0) & (old[19]==1)) prm_spr(hide19);

if ((tek[20]==0) & (old[20]==1)) prm_spr(hide20);

if ((tek[21]==0) & (old[21]==1)) prm_spr(hide21);

if ((tek[22]==0) & (old[22]==1)) prm_spr(hide22);

if ((tek[23]==0) & (old[23]==1)) {
prm_spr(hide23);
prm_spr(hide24);
}

if ((tek[24]==0) & (old[24]==1)) {
prm_spr(hide25);
prm_spr(hide26);
prm_spr(hide27);
}

if ((tek[25]==0) & (old[25]==1)) {
prm_spr(hide28);
prm_spr(hide29);
}

if ((tek[26]==0) & (old[26]==1)) {
prm_spr(hide30);
prm_spr(hide31);
prm_spr(hide32);
prm_spr(hide33);
}

if ((tek[27]==0) & (old[27]==1)) {
prm_spr(hide34);
prm_spr(hide35);
prm_spr(hide36);
prm_spr(hide37);
}

if ((tek[28]==0) & (old[28]==1)) {
prm_spr(hide38);
prm_spr(hide39);
prm_spr(hide40);
prm_spr(hide41);
}


if ((tek[29]==0) & (old[29]==1)) {
prm_spr(hide42);
prm_spr(hide43);
prm_spr(hide44);
}


if ((tek[30]==0) & (old[30]==1)) {
prm_spr(hide45);
prm_spr(hide46);
prm_spr(hide47);
prm_spr(hide48);
prm_spr(hide49);
}

if ((tek[31]==0) & (old[31]==1)) {
prm_spr(hide50);
prm_spr(hide51);
prm_spr(hide52);
prm_spr(hide53);
}

if ((tek[32]==0) & (old[32]==1)) {
prm_spr(hide54);
prm_spr(hide55);
prm_spr(hide56);
}
//
if ((tek[33]==0) & (old[33]==1))prm_spr(hide57);

if ((tek[34]==0) & (old[34]==1))prm_spr(hide58);

if ((tek[35]==0) & (old[35]==1))prm_spr(hide59);
//
if ((tek[36]==0) & (old[36]==1)) {
prm_spr(hide60);
prm_spr(hide61);
}

//   
unsigned char u;
for (u=0;u<37;u++) {old[u]=tek[u];}

}

//    
void InitStartGame()
{
unsigned char u;
for (u=0;u<37;u++) {tek[u]=0;old[u]=0;}
firepos=29;
firepause=0;
movepause=0;
chelpos=26;
tekmove=21;
total=0;
bad=0;
kp=0;
}

//  
void ShowFire()
{
firepause++;
tek[firepos]=1;
if (firepause==cFirePause)  
		{
		tek[firepos]=0;
		firepos++;
		if (firepos==33) firepos=29;
		tek[firepos]=1;
		firepause=0;
		}
}

// 
void ShowChel()
{
tek[26]=0;tek[27]=0;tek[28]=0;
tek[chelpos]=1;
}

unsigned char MoveChel()
{
unsigned char p;
p=PINC;
if (p==255) kp=0;
if (((p & VK_KEY6)==0)&&(chelpos!=28)&&(kp==0)) {chelpos++;kp=1;} 
if (((p & VK_KEY4)==0)&&(chelpos!=26)&&(kp==0)) {chelpos--;kp=1;} 
return p;
}


unsigned char FindLastCH(unsigned char i)
{
unsigned char u;
u=i;
while (u!=0)
	{
		if (tek[u]==1) return u;
		u--;
	}
	if (tek[0]==0) u=255;
	return u;
}



void draw_score(unsigned char score, unsigned char lines)
{
  char text[] = "000 ";
  for(unsigned char i=2; i>0; i--)
  {
    text[i] = 0x30 + score % 10;
    score/=10;
  }
  put_string8(145,15,text,0x00,0xFF);

  for(unsigned char i=2; i>0; i--)
  {
    text[i] = 0x30 + lines % 10;
    lines/=10;
  }
  put_string8(145,28,text,0x00,0xFF);
}


void FlashUpal(unsigned char i)
{
unsigned char p;
unsigned char o;
tek[i]=0;
if (i==4) o=23;
if (i==12) o=24;
if (i==18) o=25;
for (p=1;p<4;p++) 
{
	tek[o]=1;
	RefreshScreen();
	_delay_ms(300);
	tek[o]=0;
	RefreshScreen();
	_delay_ms(300);
}




}

void MoveVertva()
{
movepause++;
if (movepause==cMovePause) 
	{
	movepause=0;
	tekmove=FindLastCH(tekmove);

	if ((tekmove==4)&&(chelpos!=26)) {FlashUpal(tekmove);bad++;draw_score(total,bad);return;}
	if ((tekmove==12)&&(chelpos!=27)) {FlashUpal(tekmove);bad++;draw_score(total,bad);return;}
	if ((tekmove==18)&&(chelpos!=28)) {FlashUpal(tekmove);bad++;draw_score(total,bad);return;}


	if (tekmove==255) 
		{
			tekmove=21;
			if ((rand() % 10)>=8) tek[0]=1; 	
		} 
		else
		{
			tek[tekmove]=0;
			if (tekmove!=21) tek[tekmove+1]=1;
			if (tekmove==21) {total++;draw_score(total,bad);}
		}

	}

}


void PlayGame()
{
draw_score(total,bad);
unsigned char k;
tek[0]=1;
while (1)
{
	k=MoveChel();
	if ((k & VK_KEY1)==0) {wait_key_unpressed();break;}
	if ((k & VK_KEY2)==0) {ls020_off_lcd();while (1){}}
	ShowFire();
	ShowChel();
	MoveVertva();
	RefreshScreen();
	if (bad==20) break;
}
}



void main (void)
{
  keyboard_init(); 
  lcd_init(clWhite);
  sdcard_init();

  while (1) 
  {
  ShowStartScreen();
  InitStartGame();
  PlayGame();
  ShowEndScreen();
  }
}
